//+------------------------------------------------------------------+
//|                                     Fractals - adjustable period |
//+------------------------------------------------------------------+
#property link      "www.forex-station.com"
#property copyright "www.forex-station.com"

#property indicator_separate_window
#property indicator_buffers 8
#property indicator_color2  LimeGreen
#property indicator_color1  PaleVioletRed
#property indicator_color4  LimeGreen
#property indicator_color3  PaleVioletRed
#property indicator_color6  LimeGreen
#property indicator_color5  PaleVioletRed
#property indicator_color8  LimeGreen
#property indicator_color7  PaleVioletRed
#property indicator_minimum 0
#property indicator_maximum 5

//
//
//
//
//

extern string              TimeFrame1            = "Current time frame";
extern string              TimeFrame2            = "next1";
extern string              TimeFrame3            = "next2";
extern string              TimeFrame4            = "next3";
extern int                 FractalPeriod         = 25;
extern ENUM_APPLIED_PRICE  PriceHigh             = PRICE_HIGH;
extern ENUM_APPLIED_PRICE  PriceLow              = PRICE_LOW;
extern bool                alertsOn              = false;
extern bool                alertsMessage         = true;
extern bool                alertsSound           = false;
extern bool                alertsEmail           = false;
extern bool                alertsNotify          = false;
extern string              UniqueID              = "4 Time fractals";
extern int                 LinesWidth            =  0;
extern color               LabelsColor           = DarkGray;
extern int                 LabelsHorizontalShift = 5;
extern double              LabelsVerticalShift   = 1.5;
extern bool                InheritValues         = true;

//
//
//
//
//

double UpperBuffer[];
double LowerBuffer[];
double UpperBuffer1[];
double LowerBuffer1[];
double UpperBuffer2[];
double LowerBuffer2[];
double UpperBuffer3[];
double LowerBuffer3[];

int    timeFrames[4];
bool   returnBars;
bool   calculateValue;
string indicatorFileName;

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int init()
{
   SetIndexBuffer(0,UpperBuffer);
   SetIndexBuffer(1,LowerBuffer);
   SetIndexBuffer(2,UpperBuffer1);
   SetIndexBuffer(3,LowerBuffer1);
   SetIndexBuffer(4,UpperBuffer2);
   SetIndexBuffer(5,LowerBuffer2);
   SetIndexBuffer(6,UpperBuffer3);
   SetIndexBuffer(7,LowerBuffer3);
      for (int i=0; i<8; i++) 
      {
         SetIndexStyle(i,DRAW_ARROW,EMPTY,LinesWidth); SetIndexArrow(i,110); 
      }
      if (MathMod(FractalPeriod,2)==0)
         FractalPeriod = FractalPeriod+1;
         indicatorFileName = WindowExpertName();
         returnBars        = (TimeFrame1=="returnBars");     if (returnBars)     return(0);
         calculateValue    = (TimeFrame1=="calculateValue"); if (calculateValue) return(0);
      timeFrames[0] = stringToTimeFrame(TimeFrame1);
      timeFrames[1] = stringToTimeFrame(TimeFrame2);
      timeFrames[2] = stringToTimeFrame(TimeFrame3);
      timeFrames[3] = stringToTimeFrame(TimeFrame4);
      IndicatorShortName(UniqueID);
return(0);
}

int deinit()
{
   for (int t=0; t<4; t++) ObjectDelete(UniqueID+t);
   return(0); 
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

int start()
{
   int counted_bars=IndicatorCounted();
      if(counted_bars<0) return(-1);
      if(counted_bars>0) counted_bars--;
         int limit=MathMin(MathMax(Bars-counted_bars,FractalPeriod),Bars-1);
         if (returnBars) { UpperBuffer[0] = limit+1; return(0); }

   //
   //
   //
   //
   //

   if (calculateValue)
   {
      for(int i=limit; i>=0; i--)
      {
         int half = FractalPeriod/2;
         bool   found     = true;
         double compareTo = iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i);
         for (int k=1;k<=half;k++)
            {
               if ((i+k)<Bars && iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i+k)> compareTo) { found=false; break; }
               if ((i-k)>=0   && iMA(NULL,0,1,0,MODE_SMA,PriceHigh,i-k)>=compareTo) { found=false; break; }
            }
         if (found) 
               UpperBuffer[i]=High[i];
         else  UpperBuffer[i]=EMPTY_VALUE;

         //
         //
         //
         //
         //
      
         found     = true;
         compareTo = iMA(NULL,0,1,0,MODE_SMA,PriceLow,i);
         for (k=1;k<=half;k++)
            {
               if ((i+k)<Bars && iMA(NULL,0,1,0,MODE_SMA,PriceLow,i+k)< compareTo) { found=false; break; }
               if ((i-k)>=0   && iMA(NULL,0,1,0,MODE_SMA,PriceLow,i-k)<=compareTo) { found=false; break; }
            }
         if (found)
              LowerBuffer[i]=Low[i];
         else LowerBuffer[i]=EMPTY_VALUE;
      }
      
      //
      //
      //
      //
      //
      
      if (alertsOn)
      {
         static datetime previousLevel = -1; static int previousSignal = 0;
         int currentBar=-1;
               for (i=0; i<Bars-1; i++) if (LowerBuffer[i]!=EMPTY_VALUE || UpperBuffer[i]!=EMPTY_VALUE) { currentBar = i; break; }
         if (currentBar>-1) checkAlert(currentBar,previousLevel,previousSignal,UpperBuffer,LowerBuffer ,"");
      }
      return(0);
   }      

   //
   //
   //
   //
   //

         bool initialized = false;
         if (!initialized)
         {
            initialized = true;
            int window = WindowFind(UniqueID);
            for (int t=0; t<4; t++)
            {
               string label = timeFrameToString(timeFrames[t]);
               ObjectCreate(UniqueID+t,OBJ_TEXT,window,0,0);
                  ObjectSet(UniqueID+t,OBJPROP_COLOR,LabelsColor);
                  ObjectSet(UniqueID+t,OBJPROP_PRICE1,t+LabelsVerticalShift);
                  ObjectSetText(UniqueID+t,label,8,"Arial");
            }               
         }
         for (t=0; t<4; t++) ObjectSet(UniqueID+t,OBJPROP_TIME1,Time[0]+Period()*LabelsHorizontalShift*60);

   //
   //
   //
   //
   //
      
   if (timeFrames[0] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[0],indicatorFileName,"returnBars",0,0)*timeFrames[0]/Period()));
   if (timeFrames[1] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[1],indicatorFileName,"returnBars",0,0)*timeFrames[1]/Period()));
   if (timeFrames[2] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[2],indicatorFileName,"returnBars",0,0)*timeFrames[2]/Period()));
   if (timeFrames[3] != Period()) limit = MathMax(limit,MathMin(Bars-1,iCustom(NULL,timeFrames[3],indicatorFileName,"returnBars",0,0)*timeFrames[3]/Period()));
   for(i=limit; i>=0; i--)
   {
      if (InheritValues)
      {
         UpperBuffer[i]  = UpperBuffer[i+1];  
         LowerBuffer[i]  = LowerBuffer[i+1];
         UpperBuffer1[i] = UpperBuffer1[i+1];  
         LowerBuffer1[i] = LowerBuffer1[i+1];
         UpperBuffer2[i] = UpperBuffer2[i+1];  
         LowerBuffer2[i] = LowerBuffer2[i+1];
         UpperBuffer3[i] = UpperBuffer3[i+1];  
         LowerBuffer3[i] = LowerBuffer3[i+1];
      }
      else
      {
         UpperBuffer[i]  = EMPTY_VALUE;
         LowerBuffer[i]  = EMPTY_VALUE;
         UpperBuffer1[i] = EMPTY_VALUE;
         LowerBuffer1[i] = EMPTY_VALUE;
         UpperBuffer2[i] = EMPTY_VALUE;
         LowerBuffer2[i] = EMPTY_VALUE;
         UpperBuffer3[i] = EMPTY_VALUE;
         LowerBuffer3[i] = EMPTY_VALUE;
      }         

      //
      //
      //
      //
      //
      
      double up;
      double dn;
      for (k=0; k<4; k++)
      {
         int y = iBarShift(NULL,timeFrames[k],Time[i]);
         int x = iBarShift(NULL,timeFrames[k],Time[i+1]);
         if (x!=y)
         {
            switch (k)
            {
               case 0: 
                     up = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,alertsOn,alertsMessage,alertsSound,alertsEmail,0,y);
                     dn = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,alertsOn,alertsMessage,alertsSound,alertsEmail,1,y);
                        if (up!=EMPTY_VALUE) { UpperBuffer[i] = 1; LowerBuffer[i] = EMPTY_VALUE; }
                        if (dn!=EMPTY_VALUE) { LowerBuffer[i] = 1; UpperBuffer[i] = EMPTY_VALUE; }
                     break;
               case 1: 
                     up = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,alertsOn,alertsMessage,alertsSound,alertsEmail,0,y);
                     dn = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,alertsOn,alertsMessage,alertsSound,alertsEmail,1,y);
                        if (up!=EMPTY_VALUE) { UpperBuffer1[i] = 2; LowerBuffer1[i] = EMPTY_VALUE; }
                        if (dn!=EMPTY_VALUE) { LowerBuffer1[i] = 2; UpperBuffer1[i] = EMPTY_VALUE; }
                     break;
               case 2: 
                     up = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,alertsOn,alertsMessage,alertsSound,alertsEmail,0,y);
                     dn = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,alertsOn,alertsMessage,alertsSound,alertsEmail,1,y);
                        if (up!=EMPTY_VALUE) { UpperBuffer2[i] = 3; LowerBuffer2[i] = EMPTY_VALUE; }
                        if (dn!=EMPTY_VALUE) { LowerBuffer2[i] = 3; UpperBuffer2[i] = EMPTY_VALUE; }
                     break;
               case 3: 
                     up = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,alertsOn,alertsMessage,alertsSound,alertsEmail,0,y);
                     dn = iCustom(NULL,timeFrames[k],indicatorFileName,"calculateValue","","","",FractalPeriod,PriceHigh,PriceLow,alertsOn,alertsMessage,alertsSound,alertsEmail,1,y);
                        if (up!=EMPTY_VALUE) { UpperBuffer3[i] = 4; LowerBuffer3[i] = EMPTY_VALUE; }
                        if (dn!=EMPTY_VALUE) { LowerBuffer3[i] = 4; UpperBuffer3[i] = EMPTY_VALUE; }
                     break;
            }
         }
      }
   }            
   return(0);
}

//+------------------------------------------------------------------+
//|                                                             
//+------------------------------------------------------------------+
//
//
//
//
//

void checkAlert(int currentBar, datetime& previousLevel, int& previousSignal, double& upBuffer[], double& dnBuffer[], string text)
{
   int previousBar = iBarShift(NULL,0,previousLevel);
   int currentSignal;
         if (upBuffer[currentBar]!=EMPTY_VALUE)                                      currentSignal = -1;
         if (dnBuffer[currentBar]!=EMPTY_VALUE)                                      currentSignal =  1;
         if (dnBuffer[currentBar]!=EMPTY_VALUE && upBuffer[currentBar]!=EMPTY_VALUE) currentSignal =  0;

   //
   //
   //
   //
   //
   
   if (currentBar != previousBar || currentSignal != previousSignal)
   {
      if (currentSignal != previousSignal && currentBar > previousBar && previousLevel != -1)
            string alertText = "reverted to ";
      else         alertText = "current signal ";            
      switch(currentSignal)
      {
         case  0 : doAlert(text+alertText+"up/down"); break;
         case  1 : doAlert(text+alertText+"up");      break;
         case -1 : doAlert(text+alertText+"down");
      }               
 
      //
      //
      //
      //
      //
              
      previousLevel  = Time[currentBar];
      previousSignal = currentSignal;
   }
}

//
//
//
//
//

void doAlert(string doWhat)
{
   string message =  timeFrameToString(Period())+" "+Symbol()+" at "+TimeToStr(TimeLocal(),TIME_SECONDS)+" Fractals "+doWhat;
      if (alertsMessage) Alert(message);
      if (alertsEmail)   SendMail(StringConcatenate(Symbol(),"Fractals"),message);
      if (alertsSound)   PlaySound("alert2.wav");
      if (alertsNotify)  SendNotification(message);
}

//-------------------------------------------------------------------
//
//-------------------------------------------------------------------
//
//
//
//
//

string sTfTable[] = {"M1","M5","M15","M30","H1","H4","D1","W1","MN"};
int    iTfTable[] = {1,5,15,30,60,240,1440,10080,43200};

//
//
//
//
//

int toInt(double value) { return(value); }
int stringToTimeFrame(string tfs)
{
   tfs = stringUpperCase(tfs);
   int max = ArraySize(iTfTable)-1, add=0;
   int nxt = (StringFind(tfs,"NEXT1")>-1); if (nxt>0) { tfs = ""+Period(); add=1; }
       nxt = (StringFind(tfs,"NEXT2")>-1); if (nxt>0) { tfs = ""+Period(); add=2; }
       nxt = (StringFind(tfs,"NEXT3")>-1); if (nxt>0) { tfs = ""+Period(); add=3; }

      //
      //
      //
      //
      //
         
      for (int i=max; i>=0; i--)
         if (tfs==sTfTable[i] || tfs==""+iTfTable[i]) return(MathMax(iTfTable[toInt(MathMin(max,i+add))],Period()));
                                                      return(Period());
}
string timeFrameToString(int tf)
{
   for (int i=ArraySize(iTfTable)-1; i>=0; i--) 
         if (tf==iTfTable[i]) return(sTfTable[i]);
                              return("");
}

//
//
//
//
//

string stringUpperCase(string str)
{
   string   s = str;

   for (int length=StringLen(str)-1; length>=0; length--)
   {
      int xchar = StringGetChar(s, length);
         if((xchar > 96 && xchar < 123) || (xchar > 223 && xchar < 256))
                     s = StringSetChar(s, length, xchar - 32);
         else if(xchar > -33 && xchar < 0)
                     s = StringSetChar(s, length, xchar + 224);
   }
   return(s);
}